/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iDate vec4(0.0,0.0,0.0,iGlobalTime)

/////////////////////////////////////////////////////////////////////////////////

/* Compiled with Shaderforth: https://github.com/daeken/Shaderforth
:globals
	@vec3 uniform =iResolution
	@float uniform =iGlobalTime
	@vec4 uniform =iDate
;
:m gtime iGlobalTime ;

:m overlap 5 ;

: split ( p:vec2 time:float -> vec3 )
	p cart->polar =pol
	[
			pol .y 10 / time 7.1 / + sin 10 /
			pol .y 100 * sin 350 /
		+
		0
	] pol + pi 2 * mod =pol
	pol .x 60 deg->rad mod 30 deg->rad - 30 deg->rad / =dist

	0 =top
	{ dist 30 overlap + deg->rad 30 deg->rad / / =dist 1 =top }
	{
		{ dist 30 overlap - deg->rad 30 deg->rad / / =dist }
		{
				1 dist abs - 1 + dist sign neg *
				30 overlap + deg->rad 30 deg->rad /
			/ =dist
			1 =top
		} dist abs 30 overlap - deg->rad 30 deg->rad / < if
	}
	pol .x 120 deg->rad mod 60 deg->rad >= if

	[
		dist abs
		pol .y
		top
	]
;

: warp ( ip:vec3 time:float -> vec3 )
	ip [
		time 5 / ip .y + sin 10 /
			time 3.7 / ip .x + sin 100 /
			1 ip .z - 75 /
		+
		0
	] +
;

:m matunion { .x } amin ;

: shape ( to:float p:vec2 -> vec2 )
	gtime to + =time

	p time split time warp =flower

	[
		flower .y 1 flower .x 2 / - -
		flower .x
	]
;

: shape-deriv ( p:vec2 -> float )
	$[-.1:+.1:.05] !size =>len
		/{ p shape .x }
	\+ len /
;

:m petal-color [ .95 .95 0 ] ;
:m interior-color [ 1 .8 0 ] ;
:m stamen-color [ 1 1 0 ] ;

:m earth-color [ .67 .30 .05 ] ;
:m leaf-color [ .10 .39 .08 ] ;
:m stem-color [ .10 .70 .06 ] ;

: background ( p:vec2 -> vec3 )
		{ [
			stem-color
			p .x p .y + 7.1 * sin abs .3 * .7 +
			p .x 3.7 * sin abs .5 * .5 +
			p .x 57 * p .y 13 * + sin abs .1 * .9 +
			p .x 2 * .5 +
		] /abs \* }
		{ [
			[
				earth-color
				p .x p .y .3 + * sin
				p .x 3.7 * p .y -1.1 * + gtime 3.7 / + sin
			] /abs \*
			[
				leaf-color
				p .x p .y .7 * + gtime 7.9 / + sin
				p .y 3.7 * sin
			] /abs \*
		] /{ 0 1 clamp } \+ }
			p .x p .y .3 gtime 3.7 / sin .05 * + * + abs p .y 7.9 * sin .02 * + .1 <
			p .y 0 <
		and if
;

: texture ( d:float p:vec2 -> vec3 )
	{ gtime split .x } p gradient =dist
	p gtime split gtime warp =flower
	p cart->polar =pol
		{
			[
				petal-color
				d neg 500 * 0 1 clamp
				dist 90 * pol .y pol .x 79 * sin * * 1 pol .y - 20 * + sin abs .05 * .95 +
				flower .z .9 + 0 1 clamp
			] \*
			d sign 1 + 2 / p background *
		+ }
		{
				{ [
					interior-color
					.5 1 pol .y 5 * smoothstep .2 +
					pol .x 13 * sin pol .x 9 * sin * abs .1 * .9 +
				] \* }
				{ [
					stamen-color
					pol .y 137 * sin pol .x 17 * sin * abs .7 * .3 +
				] \* }
				pol .y .05 >
			if
		}
		pol .y pol .x p .x + 17 * sin .01 * .3 + >
	if
;

iResolution frag->position =p
&shape-deriv p gradient p texture ->fragcolor
*/

vec3 background(vec2 p) {
	vec3 temp_11;
	if((((abs(((p).x) + (((p).y) * (0.3 + ((sin((iGlobalTime) / 3.7)) * 0.05))))) + ((sin(((p).y) * 7.9)) * 0.02)) < 0.1) && (((p).y) < 0.0)) {
		temp_11 = ((((abs(vec3(0.1, 0.7, 0.06))) * (abs(((abs(sin((((p).x) + ((p).y)) * 7.1))) * 0.3) + 0.7))) * (abs(((abs(sin(((p).x) * 3.7))) * 0.5) + 0.5))) * (abs(((abs(sin((((p).x) * 57.0) + (((p).y) * 13.0)))) * 0.1) + 0.9))) * (abs((((p).x) * 2.0) + 0.5));
	} else {
		temp_11 = (clamp(((abs(vec3(0.67, 0.3, 0.05))) * (abs(sin(((p).x) * (((p).y) + 0.3))))) * (abs(sin(((((p).x) * 3.7) + (((p).y) * -1.1)) + ((iGlobalTime) / 3.7)))), 0.0, 1.0)) + (clamp(((abs(vec3(0.1, 0.39, 0.08))) * (abs(sin((((p).x) + (((p).y) * 0.7)) + ((iGlobalTime) / 7.9))))) * (abs(sin(((p).y) * 3.7))), 0.0, 1.0));
	}
	return temp_11;
}
vec3 warp(vec3 ip, float time) {
	return (ip) + (vec3((sin(((time) / 5.0) + ((ip).y))) / 10.0, ((sin(((time) / 3.7) + ((ip).x))) / 100.0) + ((1.0 - ((ip).z)) / 75.0), 0.0));
}
vec2 cart_polar(vec2 p) {
	return vec2(atan((p).y, (p).x), length(p));
}
vec3 split(vec2 p, float time) {
	float dist;
	float top;
	vec2 pol = cart_polar(p);
	pol = mod((vec2(((sin((((pol).y) / 10.0) + ((time) / 7.1))) / 10.0) + ((sin(((pol).y) * 100.0)) / 350.0), 0.0)) + (pol), 6.28318);
	dist = ((mod((pol).x, 1.04719666667)) - 0.523598333333) / 0.523598333333;
	top = 0.0;
	if((mod((pol).x, 2.09439333333)) >= 1.04719666667) {
		dist = (dist) / 1.16666666667;
		top = 1.0;
	} else {
		if((abs(dist)) < 0.833333333333) {
			dist = (dist) / 0.833333333333;
		} else {
			dist = (((1.0 - (abs(dist))) + 1.0) * (- (sign(dist)))) / 1.16666666667;
			top = 1.0;
		}
	}
	return vec3(abs(dist), (pol).y, top);
}
vec2 shape(float to, vec2 p) {
	float time = (iGlobalTime) + (to);
	vec3 flower = warp(split(p, time), time);
	return vec2(((flower).y) - (1.0 - (((flower).x) / 2.0)), (flower).x);
}
vec3 texture(float d, vec2 p) {
	vec3 temp_36;
	vec3 temp_32;
	vec2 h = vec2(1e-05, 0.0);
	float dist = ((split(p, iGlobalTime)).x) / (abs(length((vec2(((split((p) + (h), iGlobalTime)).x) - ((split((p) - (h), iGlobalTime)).x), ((split((p) + ((h).yx), iGlobalTime)).x) - ((split((p) - ((h).yx), iGlobalTime)).x))) / (2.0 * ((h).x)))));
	vec3 flower = warp(split(p, iGlobalTime), iGlobalTime);
	vec2 pol = cart_polar(p);
	if(((pol).y) > (((sin((((pol).x) + ((p).x)) * 17.0)) * 0.01) + 0.3)) {
		temp_32 = ((((vec3(0.95, 0.95, 0.0)) * (clamp((- (d)) * 500.0, 0.0, 1.0))) * (((abs(sin((((dist) * 90.0) * (((pol).y) * (sin(((pol).x) * 79.0)))) + ((1.0 - ((pol).y)) * 20.0)))) * 0.05) + 0.95)) * (clamp(((flower).z) + 0.9, 0.0, 1.0))) + ((((sign(d)) + 1.0) / 2.0) * (background(p)));
	} else {
		if(((pol).y) > 0.05) {
			temp_36 = ((vec3(1.0, 0.8, 0.0)) * ((smoothstep(0.5, 1.0, ((pol).y) * 5.0)) + 0.2)) * (((abs((sin(((pol).x) * 13.0)) * (sin(((pol).x) * 9.0)))) * 0.1) + 0.9);
		} else {
			temp_36 = (vec3(1.0, 1.0, 0.0)) * (((abs((sin(((pol).y) * 137.0)) * (sin(((pol).x) * 17.0)))) * 0.7) + 0.3);
		}
		temp_32 = temp_36;
	}
	return temp_32;
}
float shape_deriv(vec2 p) {
	return ((((((shape(-0.1, p)).x) + ((shape(-0.05, p)).x)) + ((shape(0.0, p)).x)) + ((shape(0.05, p)).x)) + ((shape(0.1, p)).x)) / 5.0;
}
void main() {
	vec2 p = (((((gl_FragCoord).xy) / ((iResolution).xy)) * 2.0) - 1.0) * (vec2(((iResolution).x) / ((iResolution).y), 1.0));
	vec2 h = vec2(1e-05, 0.0);
	gl_FragColor = vec4(texture((shape_deriv(p)) / (abs(length((vec2((shape_deriv((p) + (h))) - (shape_deriv((p) - (h))), (shape_deriv((p) + ((h).yx))) - (shape_deriv((p) - ((h).yx))))) / (2.0 * ((h).x))))), p), 1.0);
}
